*******************************************************************************
*                         680xx Grundprogramm Except                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                           Exceptionbehandlung                               *
*******************************************************************************


traprts:                        * Trap ausfhren (Alte Version)
 lea basis(pc),a5
 adda.l ramstart(pc),a5         * a5 erstmal setzen
 cmp #192,d7
 bhi.s traprerr                 * Zu Gro -> Fehler
 add d7,d7
 add d7,d7                      * Mal 4, da Langwort
 lea traptab.w,a6
 movea.l -4(a6,d7.w),a6
jmp (a6)                        * Sprung zum Unterprogramm

traprerr:
tnotimp:
rts                             * Nicht initialisierter Trap

trap1a:                         * Trap-Routine jetzige Version
 lea basis(pc),a5
 adda.l ramstart(pc),a5         * a5 neu setzen
 cmp #192,d7
 bhi.s traperr                  * Auerhalb des Bereichs
 add d7,d7
 add d7,d7                      * Mal 4, da Langwort-Tabelle
 lea traptab.w,a6
 movea.l -4(a6,d7.w),a6
 jsr (a6)
 move sr,d7                     * Statusregister nach d7
 move.b d7,1(a7)                * Nur Flags ndern, Statusregister bleibt
traperr:                        * erhalten
trap0a:
rte                             * Ende mit RTE nicht mir RTS

intlvx:                         * Falscher Interrupt
 lea inttxt(pc),a6
bra.s error

buserr:                         * Busfehler
 lea bustxt(pc),a6
bra.s spezerr

adrerr:                         * Adressfehler
 lea adrftxt(pc),a6
bra.s spezerr

illins:                         * Falscher Befehl
 lea illtxt(pc),a6
bra.s error

zerdiv:                         * Division durch Null
 lea zertxt(pc),a6
bra.s error

chkins:                         * Check-Befehl
 lea chktxt(pc),a6
bra.s error

trapvins:                       * Trap-Fehler
 lea traptxt(pc),a6
bra.s error

priv:                           * Privilege-Verletzung
 lea privtxt(pc),a6
bra.s error

lineaer:                        * Befehlscode $AXXX
 lea linatxt(pc),a6
bra.s error

linefer:                        * Befehlscode $FXXX
 lea linftxt(pc),a6
bra.s error

format:                         * Falsches Stackformat (Ab 68010)
  lea formattxt(pc),a6
bra.s error

spezerr:                        * Einsprung Adress- und Busfehler
 addq.l #8,a7                   * Mehr Daten auf dem Stack, die abgebaut werden
                                * Beim 68010 mu der Befehl gestrichen werden

error:                          * Fehlerbehandlung
 move.l a5,-(a7)                * a5 retten
 lea basis(pc),a5               * a6 geht verloren
 adda.l ramstart(pc),a5         * a5 neu belegen fr Grundprogramm Variablen
 movem.l d0-d7/a0-a5,regsave(a5)* Register retten
 move.l (a7)+,regsave+13*4(a5)  * a5 auch
 move (a7)+,srsave(a5)          * Statusregister
 move.l (a7)+,pcsave(a5)        * Programmcounter
 move.l a7,regsave+15*4(a5)     * a7 auch retten
 move.l usp,a0                  * USP holen
 move.l a0,uspsave(a5)          * und retten
 move.l a7,sspsave(a5)          * SSP extra retten
 lea stack(a5),a7               * Dummy Stack
 clr.b flip(a5)
 clr.b flip1(a5)                * Keine Seitenumschaltung
 clr.b page1.w                  * Kein Scroll mehr
 bsr erakreuz                   * Fadenkreuz aus
 movea.l a6,a0                  * a6 nach a0 fr Textausgabe
 bsr headaclr                   * Text mittig ausgeben
 tas.b menflag(a5)              * Nach Reset wieder mit Hardcopy
 bsr regdump                    * Debug-Info ausgeben
errlp:
 bsr ki                         * Zeichen von Tastatur
 cmp.b #'M',d0                  * 'M' bringt Neustart
 beq start                      * Neu-Start
 cmp.b #'W',d0                  * 'W' bringt Warmstart
 bne.s errlp                    * Warm-Start
 bsr getstack                   * Stackbereich holen
 movea.l d0,a7                  * Ende des Rambereiches
 bclr.b #2,menflag(a5)          * Grundprogramm nicht als Aufruf
 bclr.b #4,tracflag(a5)         * Trace aus
bra smenue
                                                                                                                                              * OK, Register gerettet
traced:                         * Status-Zeilen ausgeben
 bsr trdump                     * Alle Register / DEBUG oder DIS-ASsembler
 bcs.s tracee
 btst.b #1,tracflag(a5)         * Protokol auf Drucker ?
 beq.s tracee                   * Nein
 clr.b (a1)                     * Keine Leerzeichen mehr am Ende
 lea einbuf(a5),a0              * Ja, dann DEBUG oder DIS-Assembler ausgeben
 move.l pcsave(a5),d0           * Adresse Befehl
 bsr print8x                    *